import os
import random
import string

def rename_files_in_subfolders(base_dir):
    for foldername, subfolders, filenames in os.walk(base_dir):
        if len(subfolders) == 0:  
            for filename in filenames:
                subdir = os.path.abspath(foldername)
                folder_basename = os.path.basename(subdir)
                
                base_name, ext = os.path.splitext(filename)
                
                random_suffix = ''.join(random.choices(string.ascii_uppercase + string.digits, k=5))
                
                new_filename = f"{base_name}-{random_suffix}{ext}"

                old_file_path = os.path.join(subdir, filename)
                new_file_path = os.path.join(subdir, new_filename)

                os.rename(old_file_path, new_file_path)
                print(new_file_path)
    inp = input("按回车键关闭")
rename_files_in_subfolders('X:/短剧NEW')
